/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class NetworkItemWirelessCraftingMonitor
implements INetworkItem {
    private final INetworkItemHandler handler;
    private final EntityPlayer player;
    private final ItemStack stack;
    private final int slotId;

    public NetworkItemWirelessCraftingMonitor(INetworkItemHandler handler, EntityPlayer player, ItemStack stack, int slotId) {
        this.handler = handler;
        this.player = player;
        this.stack = stack;
        this.slotId = slotId;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public boolean onOpen(INetwork network) {
        if (RS.INSTANCE.config.wirelessCraftingMonitorUsesEnergy && this.stack.func_77952_i() != 1 && ((IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() <= RS.INSTANCE.config.wirelessCraftingMonitorOpenUsage) {
            return false;
        }
        if (!network.getSecurityManager().hasPermission(Permission.MODIFY, this.player) || !network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, this.player)) {
            WorldUtils.sendNoPermissionMessage(this.player);
            return false;
        }
        this.player.openGui((Object)RS.INSTANCE, 19, this.player.func_130014_f_(), this.slotId, 0, 0);
        this.drainEnergy(RS.INSTANCE.config.wirelessCraftingMonitorOpenUsage);
        return true;
    }

    @Override
    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.wirelessCraftingMonitorUsesEnergy && this.stack.func_77952_i() != 1) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.stack.getCapability(CapabilityEnergy.ENERGY, null);
            energyStorage.extractEnergy(energy, false);
            if (energyStorage.getEnergyStored() <= 0) {
                this.handler.close(this.player);
                this.player.func_71053_j();
            }
        }
    }
}

